# Top-level Makefile for kpathsea-using programs.
INCLUDE=$(INCLUDE);../win32

# Package subdirectories, the library, and all subdirectories.
ESUBDIRS= bibtex8 cjkutils chktex dtl dvi2tty dvidvi dviljk \
	dvipdfm dvipsk gsftopk lacheck ltx2rtf makeindexk   \
	musixflx odvipsk ps2pkm seetexk tex4htk     \
	tetex ttf2pfb ttf2pk ttfdump windvi owindvi ispell  \
	texlive texdoctk # tth oxdvik xdvik
DSUBDIRS=

programs = web2c contrib $(ESUBDIRS)
kpathsea_dir = kpathsea
all_dirs = $(kpathsea_dir) $(programs)

!include <make/paths.mak>
!include <make/makevars.mak>

# It's too bad we have to pass all these down, but I see no alternative,
# if we are to propagate changes at the top level.
# XMAKEARGS is for the user to override.
# makeargs = $(MFLAGS) CC='$(CC)' CFLAGS='$(CFLAGS)' $(makevars) $(XMAKEARGS)
# installargs = INSTALL_DATA='$(INSTALL_DATA)' \
#  INSTALL_PROGRAM='$(INSTALL_PROGRAM)' $(makeargs)
makeargs = -$(MAKEFLAGS)
installargs = $(makeargs)

# Not everything from common.mk is relevant to this top-level
# Makefile, but most of it is, and it doesn't seem worth separating the
# compilation-specific stuff.
!include <make/common.mak>

# kpathsea is not a sibling, it's a child.
kpathsea_parent = .

# Make the library before the programs.
# Use if ... rather than || or && because Ultrix sh exits for
# no good reason with the latter.
default: all

all: do-kpathsea
	-@echo $(verbose) & for %%d in ($(programs)) do \
		echo Entering %%d for $@ \
		& pushd %%d & $(MAKE) $(makeargs) $@ & popd

install install-data install-exec:
	-@echo $(verbose) & for %%d in ($(all_dirs)) do \
		echo Entering %%d for $@ \
		& pushd %%d & $(MAKE) $(installargs) $@ & popd

# Other standard targets for everything.
uninstall uninstall-exec uninstall-data \
mostlyclean clean realclean extraclean configclean \
info dvi check depend::
	-@echo $(verbose) & for %%d in ($(all_dirs)) do \
		echo Entering %%d for $@ \
		& pushd %%d & $(MAKE) $(makeargs) $@ & popd

distclean::
	-@echo $(verbose) & for %%d in ($(all_dirs) $(DSUBDIRS)) do \
		echo Entering %%d for $@ \
		& pushd %%d & $(MAKE) $(makeargs) $@ & popd

distclean realclean::
	-@$(RM) *~ #* config.status config.cache config.log klibtool.config

# Unconditionally remake the library, since we don't want to write out
# the dependencies here.
do-kpathsea:
	-@echo off & echo Entering $(kpathsea_dir) for all
	-@pushd $(kpathsea_dir) & $(MAKE) $(makeargs) all & popd

# Targets that only apply to web2c.
triptrap trip trap mptrap \
formats fmts bases mems \
install-formats install-fmts install-bases install-mems \
install-links c-sources: do-kpathsea
	-@echo off & echo Entering web2c for $@
	-@pushd web2c & $(MAKE) $(makeargs) $@ & popd

#ac_dir = $(srcdir)/etc/autoconf
#autoconf = $(ac_dir)/acspecific.m4 $(ac_dir)/acgeneral.m4 $(ac_dir)/acsite.m4
#configure_in = $(srcdir)/configure.in
#$(srcdir)/configure: $(configure_in) $(srcdir)/withenable.ac $(autoconf)
#	cd $(srcdir) && autoconf -m $(ac_dir)
#
## And make sure that --enable-maintainer-mode is used if configure is
## called from the makefiles.  We do not try to do this through the
## cache, lest the option sneaks into a global cache file.
#enablemaintflag = --enable-maintainer-mode
#
#config.status: $(srcdir)/configure
#	$(SHELL) $(srcdir)/configure --no-create --verbose  $(enablemaintflag)
#
#Makefile: $(srcdir)/Makefile.in config.status
#	$(SHELL) config.status
#
#TAGS:
#	find $(srcdir) \( -name '*.[cCfFhilsy]' -o -name '*.el' \) | etags -

# Local Variables:
# mode: Makefile
# End:
