\newdimen\zwindent



\ifx\csprimeson\undefined

  \def\next{\input czech.sty }

\else

  \let\next\relax

\fi\next



\ifx\verbatim\undefined

  \def\next{\input verbatim }

\else

  \let\next\relax

\fi\next



\ifx\LaTeX\undefined

  \def\LaTeX{{\rm\La\kern-.15em\TeX}}

\fi

\ifx\La\undefined

  \def\La{L\kern-.36em\raise.3ex\hbox{\sc a}}

\fi

\ifx\pc\undefined

  \def\pc/{{\sc PerCent}}

  \nocon

  \def\@@{\spacefactor 1000 \relax}

\else

  \let\con=\endinput

  \let\inx=\endinput

  \let\fin=\endinput

  \secpagedepth=-1

\fi



\csprimesoff % This will be on when included into the document



\ifx\proc\undefined

  \edef\savedcat{\the\catcode`\@@}

  \edef\savedless{\the\catcode`\<}

  \catcode`\@@=11

  \catcode`\<=13

  \def\proc#1,#2.{\ifmmode \def\zw@@toggle{\null$\null}\else

   \let\zw@@toggle\relax \fi

    \zw@@toggle #1 \hfil $\langle\,$\_#2\_$\,\rangle$\zw@@toggle}



  \def<#1>{\ifmmode \def\zw@@toggle{\null$\null}\else

   \let\zw@@toggle\relax \fi

    \zw@@toggle $\langle\,$\_#1\_$\,\rangle$\zw@@toggle}



  \def\pa{\catcode`\<=13\relax}

  \def\pb{\catcode`\<=\savedcat\relax}

  \catcode`\<=\savedless

  \catcode`\@@=\savedcat

\fi



\ifx\specverb\undefined

  \def\specverb{\begingroup \def\obeyspaces{\catcode`\ =12}}

  \let\endspecverb=\endgroup

\fi



\def\description{\medskip

  \begingroup

  \zwindent=3.5em\relax

  \leftskip=\parindent

  \rightskip=\parindent

  \parskip=2pt

  \def\item[##1]{\ifhmode \par \fi

    \noindent \hang\hangindent\zwindent

    \hbox to\zwindent{{\bf##1}\hss}\ignorespaces}}



\def\enddescription{\medskip\endgroup}



\csprimeson

\tolerance=9999

\hbadness 5555



@** PROGRAM PERCENT. \specverb  %~+

elem tohoto programu je usnadnit psan balk (\La)\TeX ovch maker

dokumentovanch pomoc {\sc doc.sty} a~{\sc docstrip.tex}. Dokumentace

k~makrm se zapisuje do koment, makra se zapisuj mezi

\verb:%    \begin{macrocode}: a \verb:%    \end{macrocode}:. Program

umouje konverzi mezi pohodlnjm zpisem a~tvarem pro {\sc doc.sty}.



Pro snadnj zpis dokumentace existuj nsledujc pkazy, kter mus

bt psny na samostatnm dku od prvnho sloupce:



\description

\advance\zwindent by 0.5em

\item[\%+] ped vechny nsledujc neprzdn dky bude pidno procento

a~mezera.

\item[\%$-$] ru funkci \%+.

\item[\%\%+] ped vechny nsledujc neprzdn dky budou pidny dva

znaky procento a~mezera.

\item[\%\%$-$] ru funkci \%\%+.

\item[\%+++] expanduje na \verb:%    \begin{macrocode}:.

\item[\%$-$\nobreak$-$\nobreak$-$] expanduje na \verb:%    \end{macrocode}:.

\enddescription



Tato funkce se vyvol pkazem:\medskip



{\tt percent +<{\it filename\/}>}\medskip



\noindent kde {\it filename\/} je pln jmno souboru. Soubor bude nahrazen

konvertovanou verz, pvodn soubor bude uschovn v~souboru s~pponou

{\tt .bak}.



Opan konverze se provede pkazem:\medskip



{\tt percent $-$<{\it filename\/}>}\medskip



Zatmco v~pvodnm souboru mete libovoln mchat pkazy \%+++ 

a~\%$-$\nobreak$-$\nobreak$-$

s~\verb:%    \begin{macrocode}: a \verb:%    \end{macrocode}:, pi zptn

konverzi budou vechny vskyty \verb:%    \begin{macrocode}: i

\verb:%    \end{macrocode}: pevedeny na \%+++ a \%$-$\nobreak$-$\nobreak$-$.



@ Program bude mt nsledujc sti.  %~-



@c

@<Hlavikov soubory@>@;

@<Prototypy@>@;

@<Globln promnn@>@;

@<Hlavn program@>@;

@<Funkce@>@;



@ %~+

Jak pozdji uvidme, budeme potebovat nsledujc hlavikov soubory.

(Samozejm bychom tuto sekci mohli rozdlit na mnoho malch fragment

a~natat kad hlavikov soubor vdy, kdy se pouije funkce v~nm

definovan. Podle mho nzoru to ale k~pehlednosti programu nepispje.)

%~-



@<Hlavi...@>=

#include <dir.h>

#include <io.h>

#include <fcntl.h>

#include <string.h>

#include <fstream.h>

#include <ibmanip.h>

#include <useful.h>

#include <stdlib.h>

#include <ctype.h>



@ %~+

Hlavn program mus pest parametr z~pkazovho dku. Vimnte si, e

mezi znakem + i $-$ a~jmnem souboru nen mezera. Ve se tedy pete jako

jedin parametr, take |argc| mus mt hodnotu 2. Prvn znak parametru

rozhodne o~tom, jakou funkci mme provst, zbytek se pole dl jako jmno

souboru.

%~-



@<Hlavn ...@>=

void main (int argc, const char *argv[]) {

if (argc != 2) {

  cout << "Nesprvn poet parametr\n";  return;

}

switch (*argv[1]) {

case '+':  AddPerCent (argv[1]+1); @+ break;

case '-':  RemovePerCent (argv[1]+1); @+ break;

default:   cout << "Neznm funkce; zvol + nebo -.\n";

}}



@ Pouit funkce mus mt sv prototypy.



@<Prototypy@>=

void AddPerCent (const char*);

void RemovePerCent (const char*);

int  MakeBakFile (const char*);



@ %~+

V~programu budeme potebovat ti funkce (tu tet jsme pedasn uvedli

v~sekci prototyp).

%~-



@<Funkce@>=

@<Pidej procento@>@;

@<Odstra procento@>@;

@<Udlej zlon soubor@>@;



@ %~+

Nejprve si vytvome posledn jmenovanou funkci. Ta vezme jmno souboru

jako parametr a~rozdl jej na jednotliv sti. Pak vytvo jmno, kter

m pponu {\tt.bak}. Pvodn soubor s~pponou {\tt.bak} se zru 

a~zdrojov soubor je pejmenovn. Tento soubor je pak oteven a~funkce vrt

hodnotu rukojeti souboru (file handle).

%~-



@<Udlej zlo...@>=

int MakeBakFile (const char *fn) {

char myfn[MAXPATH], fullfn[MAXPATH], dr[MAXDRIVE], dir[MAXDIR],

     fname[MAXFILE], ext[MAXEXT];

_fullpath (fullfn, fn, sizeof fullfn);

fnsplit (fullfn, dr, dir, fname, ext);

fnmerge (myfn, dr, dir, fname, ".bak");

unlink (myfn);

if (rename (fullfn, myfn)) {

  cout << "chyba vstupu/vstupu, pravdpodobn neexistujc soubor\n";

  exit(EXIT_FAILURE);

}

return open (myfn, O_RDONLY | O_TEXT);

}



@ %~+

Nsledujc funkce bude konvertovat soubor do formtu pro {\sc doc.sty},

tj.\@@ strun eeno, bude pidvat procento na zatek

dk.

%~-



@<Pidej ...@>=

void AddPerCent (const char *fn) {

@<Otevi soubory@>@;

@<Add: inicializuj lokln promnn@>@;

@<Add: zpracuj soubor@>@;

@<Zavi soubory@>@;

}



@ %~+

Pi otvrn vstupnho souboru pouijeme vlastn buffer pro zrychlen

ten a~zpisu. Jako prvn parametr v~konstruktoru pouijeme rukoje

souboru, kterou vrt funkce |MakeBakFile|.

\edef\Open{\secno}

%~-



@<Otevi ...@>=

ifstream inf (MakeBakFile (fn), inbuf, sizeof inbuf);

ofstream outf (fn);



@ Buffer musme deklarovat jako globln promnnou.



@<Globln ...@>=

char inbuf[16384];



@ Zavrn soubor nepotebuje bli vysvtlen.



@<Zavi ...@>=

outf.close (); @+ inf.close ();



@ %~+

V~tto funkci budeme pedevm potebovat promnnou, do n budeme natat

vstupn dky. Mlky budeme pedpokldat, e dek nebude mt vce ne

255~znak. Krom toho potebujeme logick promnn s~nsledujcm vznamem:



\description

\zwindent=4.5em

\item[one] zpracovv se text za pkazem \%+.

\item[two] zpracovv se text za pkazem \%\%+.

\item[macro] zpracovv se ``macrocode''. V~uritm okamiku se doasn

vyuv i~pro jin ely, co bude na pslunm mst dokumentovno.

\item[empty] posledn zpracovan dek byl przdn.

\enddescription



Vechny logick promnn se na zatku napln hodnotou~0.

%~-



@<Add: inic...@>=

char Line[256];

int one, two, macro, empty;

one = two = macro = empty = 0;



@ %~+

Dokud jsou data ve vstupnm souboru a~do vstupnho souboru lze pst,

budeme st pi kadm prchodu vdy jeden dek, zjistme, zda je przdn

a~dle provedeme podrobnj analzu a~zpracovn.

%~-



@<Add: zpracuj sou...@>=

while (inf && outf && !inf.eof()) {

  @<Add: peti dek@>@;

  @<Add: zpracuj przdn dek@>@;

  @<Add: analyzuj a zpracuj dek@>@;

}



@ %~+

Nkter editory nechvaj na konci dk mezery, co by znemonilo

sprvn rozeznvn przdnch dk. Proto po naten dku a~peskoen

vech nsledujcch znak a do \verb:\n: vetn zavolme funkci, kter

odstran koncov mezery.

\edef\ReadLine{\secno}

%~-



@<Add: peti ...@>=

inf.get (Line, sizeof Line); @+ inf >> endl; @+ CutStg (Line);



@ %~+

V~\TeX{}u przdn dek znamen konec odstavce. Dva i vce po sob

nsledujc przdn dky nemaj dn smysl, a~proto je odstranme.

Jestlie najdeme przdn dek a~pedchoz dek byl tak przdn, skome

rovnou na konec smyky. V opanm ppad musme przdn dek oetit jako

kad jin. Program {\sc docstrip} toti vkld przdn dky do vstupnho

souboru, co sice na funkci nevad, ale zbyten to pltv mstem.

%~-



@<Add: zpracuj przd...@>=

if (!*Line) {

  if (empty) continue;

  empty = 1;

}

else empty = 0;



@ %~+

Pi analze a~zpracovn dku budeme nejprve hledat zatek prosted

macrocode. Je-li nastaven pepna |macro|, budeme hledat konec prosted

macrocode. V~opanm ppad zjistme typ pkazu a~provedeme vstup.

%~-



@<Add: anal...@>=

@<Hledej begin macrocode@>@;

if (macro) {

  @<Hledej end macrocode@>@;

}

else {

  @<Zjisti typ pkazu@>@;

  @<Zapi upraven dek@>@;

}



@ %~+

Zde ppadn expandujeme \%+++. Pokud objevme zatek prosted macrocode,

nastavme pepna |macro|. Souasn si nadefinujeme |beginmac| pro

pohodlnj programovn.

\edef\BeginMac{\secno}

%~-



@d beginmac  "%    \\begin{macrocode}"



@<Hledej begin mac...@>=

if (!macro && !strcmp (Line, "%+++")) {

  strcpy (Line, beginmac); @+ macro = 1;

}

if (!macro && !strcmp (Line, beginmac)) macro = 1;



@ %~+

Pi zpracovn prosted macrocode musme nejprve otestovat a~ppadn

expandovat \%$-$\nobreak$-$\nobreak$-$. Pot zapeme dek do vstupnho

souboru a~pokud prosted

kon, vynulujeme |macro|. I~zde pouijeme definici makra pro usnadnn

ivota.

\edef\EndMac{\secno}

%~-



@d endmac    "%    \\end{macrocode}"



@<Hledej end mac...@>=

if (!strcmp (Line, "%---")) strcpy (Line, endmac);

outf << Line << endl;

if (!strcmp (Line, endmac)) macro = 0;



@ %~+

Nyn vyzkoume, zda dek obsahuje nkter ze zbvajcch pkaz. Doasn

pouijeme promnnou |macro| pro jin el. Hodnota $+1$ bude znamenat

zahjen pslunho typu zpracovn, hodnota $-1$ znamen jeho konec.

Souasn se nastav promnn |one| a~|two|. Pepna |macro| bude vynulovn

v~nsledujc sekci.

%~-



@<Zjisti typ ...@>=

if (!strcmp (Line, "%+")) { macro = 1; @+ one = 1; @+ two = 0; }

if (!strcmp (Line, "%-")) { macro = -1; @+ one = two = 0; }

if (!strcmp (Line, "%%+")) { macro = 1; @+ one = 0; @+ two = 1; }

if (!strcmp (Line, "%%-")) { macro = -1; @+ one = two = 0; }



@ %~+

Je-li nastaven pepna |macro|, je na souasnm dku formtovac pkaz

a~cel dek se ignoruje. V~opanm ppad zapeme vodn procenta podle

nastaven promnnch |one| a~|two| a~samozejm cel dek.

%~-



@<Zapi uprav...@>=

if (macro) macro = 0;

else {

  if (one) outf << "% ";

  else

  if (two) outf << "%% ";

  outf << Line << endl;

}



@ %~+

Zptn konverze je ponkud sloitj. Naprogramujeme ji tedy jako

stavov automat s~nsledujcmi deseti stavy:



\description

\zwindent=2em

\item[0:] normln vstup.

\item[1:] nalezen jeden dek zanajc znakem \%.

\item[2:] nalezeny dva dky zanajc znakem \%.

\item[3:] nalezen jeden dek zanajc znaky \%\%.

\item[4:] nalezeny dva dky zanajc znaky \%\%.

\item[5:] peruen vstupu dk typu \%.

\item[6:] peruen vstupu dk typu \%\%.

\item[7:] prosted macrocode uvnit normlnho vstupu.

\item[8:] prosted macrocode bhem vstupu dk typu \%.

\item[9:] prosted macrocode bhem vstupu dk typu \%\%.

\enddescription



Je zejm, e stavy 1--4 brn vytven hloupch sekvenc\medskip



\begingroup \parindent=0pt \obeylines%

\%+

Jednodkov koment

\%$-$

\endgroup\medskip



Nadefinujeme si tedy odpovdajc prahovou hodnotu.



@d threshold 3



@ Stavov automat mus rozeznat nsledujc typy dk:

\edef\LineTypes{\secno}



\description

\zwindent=2em

\item[0:] przdn dek.

\item[1:] dek zanajc znakem \%.

\item[2:] dek zanajc znaky \%\%.

\item[3:] \verb:%    \begin{macrocode}:.

\item[4:] \verb:%    \end{macrocode}:.

\item[5:] jin.

\enddescription



@ V~kadm stavu se provede jedna z~nsledujcch procedur:



\description

\zwindent=6em

\csprimesoff

\catcode`\<=13

\def\p<#1>{\item[<#1>]}

\csprimeson

\p<PA> zapi ve, vynuluj |idx|.

\p<KA> inkrementuj |idx|.

\p<C1> zapi vechny dky s~odstrannm znakem \%, vynuluj |idx|.

\p<MC1> zapi pkaz \%+ a~prove <C1>.

\p<C2> zapi vechny dky s~odstrannmi znaky \%\% a~vynuluj |idx|.

\p<MC2> zapi pkaz \%\%+ a~prove <C2>.

\p<KP> zapi vechny dky s~vjimkou poslednho, zkopruj dek[|idx|] do

dku[0] a~nastav |idx|=1.

\p<K1> zapi pkaz \%$-$ a~prove <KP>.

\p<K2> zapi pkaz \%\%$-$ a~prove <KP>.

\p<S1> zapi pkaz \%$-$ a~prove <PA>.

\p<S2> zapi pkaz \%\%$-$ a~prove <PA>.

\p<ERR> zobraz chybovou zprvu a~prove <PA>.

\enddescription



Definici enumerac musme zaadit mezi globln promnn, protoe je budeme

potebovat pozdji v~definici stavovho automatu.

\edef\ProcSteps{\secno}

%~-



@<Glob...@>=

enum ProcSteps {_PA_, _KA_, _C1_, _MC1_, _C2_, _MC2_, _KP_,

     _K1_, _K2_, _S1_, _S2_, _ERR_};



@ %~+

Stavov automat bude definovn jako pole struktur. Struktura mus mt

dv poloky: slo novho stavu a~oznaen procedury, kter se m provst.

Deklaraci odpovdajc struktury pidme k~definici globlnch promnnch,

pestoe zde pouze definujeme typ bez alokace pamti.

%~-



@<Glob...@>=

struct StateMachine { int NewState, ProcStep; };



@ %~+

Stavov automat je definovn nsledujc tabulkou. Ke kadmu stavu

a~typu vstupnho dku pslu slo novho stavu a~oznaen poadovan

procedury (viz sekce~\ProcSteps).



\begingroup\parfillskip=0pt \parindent=0pt

\csprimesoff % This will be on when included into the document

\ifx\proc\undefined

  \edef\savedcat{\the\catcode`\@@}

  \catcode`\@@=11

  \def\proc#1,#2.{\ifmmode \def\zw@@toggle{\null$\null}\else

   \let\zw@@toggle\relax \fi

    \zw@@toggle #1 \hfil $\langle\,$\_#2\_$\,\rangle$\zw@@toggle}



  \catcode`\@@=\savedcat

\fi



\csprimeson



\def\zwstrut{\vrule height 11pt depth 4pt width 0pt\relax}



\hbox to \hsize{\hss \vbox{\offinterlineskip

 \halign{\zwstrut\vrule\hfil #&\vrule\hfil #&\vrule\hfil #&\vrule\hfil #&

    \vrule\hfil #&\vrule\hfil #&\vrule\hfil #\vrule \cr

  \noalign{\hrule}

  Stav & przdn dek & \% & \%\% & \%$+\,+\,+$ & \%$-\,-\,-$ & jin \cr

  \noalign{\hrule}

  0 & \proc0,PA. & \proc1,KA. & \proc3,KA. & \proc7,PA. & \proc0,ERR. & \proc0,PA. \cr

  1 & \proc0,PA. & \proc1,KA. & \proc3,KP. & \proc7,PA. & \proc0,ERR. & \proc0,PA. \cr

  2 & \proc0,PA. & \proc5,MC1. & \proc3,KP. & \proc7,PA. & \proc0,ERR. & \proc0,PA. \cr

  3 & \proc0,PA. & \proc1,KP. & \proc4,KA. & \proc7,PA. & \proc0,ERR. & \proc0,PA. \cr

  4 & \proc0,PA. & \proc1,KP. & \proc6,MC2. & \proc7,PA. & \proc0,ERR. & \proc0,PA. \cr

  5 & \proc5,PA. & \proc5,C1. & \proc3,K1. & \proc8,PA. & \proc0,ERR. & \proc0,S1. \cr

  6 & \proc5,PA. & \proc1,K2. & \proc6,C2. & \proc9,PA. & \proc0,ERR. & \proc0,S2. \cr

  7 & \proc7,PA. & \proc7,PA. & \proc7,PA. & \proc7,ERR. & \proc0,PA. & \proc7,PA. \cr

  8 & \proc8,PA. & \proc8,PA. & \proc8,PA. & \proc8,ERR. & \proc0,PA. & \proc8,PA. \cr

  9 & \proc9,PA. & \proc9,PA. & \proc9,PA. & \proc9,ERR. & \proc0,PA. & \proc9,PA. \cr

  \noalign{\hrule}

 }

}\hss}

\endgroup



Pro lep hospodaen se zsobnkem budeme automat definovat globln.

%~-



@<Glob...@>=

StateMachine RM[][6] = { @|

  {{0,_PA_},{1,_KA_},{3,_KA_},{7,_PA_},{0,_ERR_},{0,_PA_}},  /* stav=0 */ @|

  {{0,_PA_},{2,_KA_},{3,_KP_},{7,_PA_},{0,_ERR_},{0,_PA_}},  /* stav=1 */ @|

  {{0,_PA_},{5,_MC1_},{3,_KP_},{7,_PA_},{0,_ERR_},{0,_PA_}}, /* stav=2 */ @|

  {{0,_PA_},{1,_KP_},{4,_KA_},{7,_PA_},{0,_ERR_},{0,_PA_}},  /* stav=3 */ @|

  {{0,_PA_},{1,_KP_},{6,_MC2_},{7,_PA_},{0,_ERR_},{0,_PA_}}, /* stav=4 */ @|

  {{5,_PA_},{5,_C1_},{3,_K1_},{8,_PA_},{0,_ERR_},{0,_S1_}},  /* stav=5 */ @|

  {{6,_PA_},{1,_K2_},{6,_C2_},{9,_PA_},{0,_ERR_},{0,_S2_}},  /* stav=6 */ @|

  {{7,_PA_},{7,_PA_},{7,_PA_},{7,_ERR_},{0,_PA_},{7,_PA_}},  /* stav=7 */ @|

  {{8,_PA_},{8,_PA_},{8,_PA_},{8,_ERR_},{5,_PA_},{8,_PA_}},  /* stav=8 */ @|

  {{9,_PA_},{9,_PA_},{9,_PA_},{9,_ERR_},{6,_PA_},{9,_PA_}}   /* stav=9 */ @|

};



@ %~+

Podobn jako pi opanm procesu, i~nyn nejprve oteveme soubory,

provedeme inicializaci promnnch, zpracujeme soubor a~nakonec vechny

soubory zaveme.

%~-



@<Odstra ...@>=

void RemovePerCent (const char *fn) {

@<Otevi soubory@>@;

@<Rem: inicializuj promnn@>@;

@<Rem: zpracuj soubor@>@;

@<Zavi sou...@>@;

}



@ %~+

Do promnn |Line| budeme natat vstupn dky a~|idx| bude obsahovat

poet natench dk. Dal promnn budou obsahovat stav automatu a~typ

procedury, kter se m provst. Jejich pesn vznam bude jasnj pozdji,

nyn pouze nkter z~nich vynulujeme.

%~-



@<Rem: inic...@>=

char Line[threshold][256];

int idx, state, empty, linetype, newstate, proctype, maxstate;

maxstate = sizeof(RM) / sizeof (RM[1]);

idx = state = empty = 0;



@



@<Rem: zpracu...@>=

while (inf && outf && !inf.eof()) {

  @<Rem: nati vstupn dek@>@;

  @<Zkontroluj stav@>@;

  @<Rem: zjisti typ dku@>@;

  @<Rem: zjisti nov stav a typ procedury@>@;

  @<Rem: zpracovn przdnho dku@>@;

  @<Prove pslunou proceduru@>@;

  @<Nastav nov stav@>@;

}



@ %~+

Po naten dku a~peskoen vech znak po \verb:\n: vetn opt

odstranme ppadn koncov mezery.

%~-



@<Rem: nati ...@>=

inf.get (Line[idx], sizeof(Line[idx])); @+ inf >> endl; @+ CutStg (Line[idx]);



@ %~+

Nyn ovme, zda je automat v~ppustnm stavu. Kontrola je vlastn

zbyten, nebo do neppustnho stavu se automat me dostat pouze tehdy,

je-li program pokozen (nap. virem).

%~-



@<Zkontroluj stav@>=

if (state < 0 || state >= maxstate) {

  cout << "Neppustn stav " << state << endl;

  cout << "Program je pokozen\n";

  exit(EXIT_FAILURE);

}



@ %~+

Dalm krokem je zjitn typu dku tak, jak je uvedeno 

v~sekci~\LineTypes. Zjiovn se provd jednoduchmi pkazy |if|, kter

nepotebuj bli koment.

%~-



@<Rem: zjisti typ ...@>=

linetype = 5;

if (!Line[idx][0]) linetype = 0;

else {

  if (!strcmp (Line[idx], beginmac)) {

    strcpy (Line[idx], "%+++"); @+ linetype = 3;

  }

  else

  if (!strcmp (Line[idx], endmac)) {

    strcpy (Line[idx], "%---"); @+ linetype = 4;

  }

  else

  if (Line[idx][0] == '%') {

    if (Line[idx][1] != '%') linetype = 1;

    else

    if (Line[idx][2] != '%') linetype = 2;

  }

}



@ %~+

Z~tabulky zjistme nov stav automatu a~typ procedury, kterou mme

provst.

%~-



@<Rem: zjisti nov...@>=

newstate = RM[state][linetype].NewState;

proctype = RM[state][linetype].ProcStep;



@ %~+

Je-li |linetype==0|, znamen to, e posledn dek je przdn. Dva a~vce

przdnch dk nemaj v~\TeX{}u vznam, proto budeme nadbyten przdn

dky ignorovat. Po przdnm dku si nastavme switch |empty|. Je-li

tento switch ji nastaven, znamen to, e i~pedchoz dek byl przdn.

V~tom ppad nastavme nov stav automatu a~skome rovnou na konec

smyky. Jestlie posledn dek nen przdn, musme vynulovat |empty|,

%~-



@<Rem: zpraco...@>=

if (linetype == 0) {

  if (empty) {

    @<Nastav nov...@>@;

    continue;

  }

  empty = 1;

}

else empty = 0;



@ Nastaven novho stavu je triviln.



@<Nastav nov...@>=

state = newstate;



@ %~+

Typ procedury mme uloen v~promnn |proctype|. Nejprve provedeme

kontrolu, zda je procedura povolena. Chyba je obvykle zpsobena patnm

vnoenm prosted ``macrocode''. Pak nsleduje rozhodovac blok pro

jednotliv typy procedur, kter byly definovny v~sekci~\ProcSteps.

%~-



@<Prove p...@>=

if (proctype == _ERR_) {

  cout << "Chyba ve vstupnm souboru; zkontroluj prosted macrocode\n";

}

signed char *s; @+ int j;

switch (proctype) {

case _ERR_:

case _S1_:

case _S2_:

case _PA_:

  @<Proc P@>@; @+ break;

case _K1_:

case _K2_:

case _KP_:

  @<Proc K@>@; @+ break;

case _MC1_:

case _MC2_:

  @<Proc M@>@;

case _C1_:

case _C2_:

  @<Proc C@>@; @+ break;

case _KA_:  idx++; @+ break;

default:

  @<Default proc@>@;

}



@ %~+

Tyto procedury mus pedevm zapsat vechny uschovan dky. Procedury

\pa<S1> a~<S2> \pb navc zap pkaz pro ukonen pslunho typu

komente.

%~-



@<Proc P@>=

if (proctype == _S1_) outf << "%-\n";

else

if (proctype == _S2_) outf << "%%-\n";

for (j = 0;  j <= idx;  j++) outf << Line[j] << endl;

idx = 0;



@ %~+

Tyto procedury se podobaj pedchozm, pouze poad pkaz je odlin 

a~navc nezapisujeme posledn dek.

%~-



@<Proc K@>=

for (j = 0;  j < idx;  j++) outf << Line[j] << endl;

if (proctype == _K1_) outf << "%-\n";

else

if (proctype == _K2_) outf << "%%-\n";

if (idx) strcpy (Line[0], Line[idx]);

if (idx) idx = 1; // vynechat, pokud bylo |idx==0|



@ %~+

Tyto procedury zap pkaz pro zahjen komente. V~pkazu |switch|

nejsou ukoneny pkazem |break|, take pokrauj do procedur \pa<C1>,

<C2>\pb.

%~-



@<Proc M@>=

if (proctype == _MC1_) outf << "%+\n";

else outf << "%%+\n";



@ %~+

Zde odstranme jeden nebo dva znaky procento (podle typu dku) a~vechny

nsledujc mezery.

%~-



@<Proc C@>=

for (j = 0;  j <= idx;  j++) {

  s = Line[j] + ((proctype == _C1_ || proctype == _MC1_) ? 1 : 2);

  while (*s > 0 && isspace(*s)) s++;

  outf << s << endl;

}

idx = 0;



@ %~+

Toto je opt situace, kter za normlnch okolnost neme nastat. Pokud

program dojde do tohoto stavu, znamen to, e je pokozen.

\endspecverb

\csprimesoff

%~-



@<Def...@>=

cout << "Program je pokozen\n";  exit(EXIT_FAILURE);



@* Rejstk.

