From:	MX%"garys@homer.boeing.com" 29-SEP-1992 12:15:49.71
To:	BED_GDG
CC:	
Subj:	globb macro for boxes in tables

Return-Path: <garys@homer.boeing.com>
Received: from atc.boeing.com by Niord.SHSU.edu (MX V3.1B) with SMTP; Tue, 29
          Sep 1992 12:10:24 CDT
Received: from HOMER.DECnet MAIL11D_V3 by atc.boeing.com (5.57) id AA04432;
          Tue, 29 Sep 92 10:04:38 PDT
Date: Tue, 29 Sep 92 10:04:37 PDT
Message-ID: <9209291704.AA04432@atc.boeing.com>
From: garys@homer.boeing.com (DWIGHT ROUSU, (206)773-8129, M/S 82-26)
To: "sty-mgr@shsu.edu"@BCSAIC
CC: 
Subject: globb macro for boxes in tables

%globb is a macro to do the setbox and boxing output for an output box which is
% either   only as wide as the text, if the text is narrow;
% or,      if the text is too wide to fit on one such line,
%          put the text in a multi-line vbox with width = hsize/ncol,
%          ( where ncol is the first argument to the macro.)
%
% Usage: \globb{#1}{#2}
% #1 is the number of columns of this width that would fit on the page.
% #2 is the text argument.
% Example: \globb{3}{Text to fit on one-third of a page.}
%          (also see example at the end of this file)
%
% This macro was originally intended to assist in assembling tables,
% (throw a globb of stuff into a table!)
% where some columns in the table may be wordy paragraphs,
% which may also be set at different sizes at different times
% ( for example in a memo and in a viewfoil (slide?).)
% This macro eliminates the need for tedious manual breakdown of
% such paragraphs into individual lines,
% and re-measuring boxes for font or page size changes.
% Despite minor remaining imperfections, it is very useful.
%
% globb was conceptualized and hacked to workable form by Dwight Rousu
%                                              <dwight@sslvax.ds.boeing.com>
% Given a wizzard massage, fixed and greatly simplified by Donald Arseneau
%                                                 <asnd@erich.triumf.ca>
% One niggle, it may leave less space below the box than you sometimes want
%             so you have to put it in by other means.
%
\newbox\globbox
\def\globb#1#2{\vtop{%                    Setting text as a paragraph first.
\divide\hsize by #1%                 hsize for globb, stays local to macro here.
%
%\advance\hsize by -1em%         This is an option for more spacious settings;
%                                reducing hsize by 1em so not against the edge.
%                                See also \quad at end  of macro.
\parindent0em%     Keep first line from being indented like a new paragraph.
%
%                  Avoid overfull boxes and underfull by (semi-)ragged right,
%                  set high tolerance for tight or loose.
\rightskip 0pt plus 2em\relax% replacing raggedright with these two lines
\xspaceskip=0pt\spaceskip=.5em plus .1em minus .2em\relax
%
\tolerance=1000\multiply\tolerance by #1
%\tolerance=10000 is infinite. Making tolerance variable here in globb,
%                              more tolerant if columns are narrower.
#2\par % typesets the text in the vtop according to the sizes and tolerance.
%
%        Now, if the text is short, back it out to be part of a line.
%        \prevgraf is the integer number of lines in the most recent paragraph.
\ifnum\prevgraf<2 %           Text fits on one line. Get that box and reset it.
   \setbox\globbox\lastbox
   \ifvoid\globbox %          Something funny input; leave line alone
   \else
      \setbox\globbox\hbox{\unhbox\globbox\unskip\unskip\unskip}% Got this?
      \nointerlineskip
      \ifdim\wd\globbox>\hsize %             It can happen?
         \hbox to\hsize{\unhbox\globbox}%
      \else
         \box\globbox
      \fi% for ifdim
   \fi%    for ifvoid
\fi%       for ifnum
}%  end of vtop
\quad%     This puts space to the right of the box. optional.
}

%Tests of globb: %           Comment all this below out after you are satisfied.
%\def\longtext{This is text for a test of globb, and a bunch of
%words behind it to test how it sets up the paragraph. It is intended
%that there be no paragraph indent, and that the globb entries be
%aligned the same as direct entered text. }
%\def\shorttext{booga}
%\globb{2}{\longtext  Arg1 is 2}
%\globb{6}{\longtext  Arg1 is 6}
%Now a test of globb follows, using globb as an entry in the halign environment
%for which it was primarily designed:
%\halign{#\hfil&&\quad#\hfil\cr
%\globb{2}{\shorttext} &\globb{3}{\longtext  One-Third} \cr
%\cr
%put in direct         &direct too                   \cr
%\cr
%\globb{1}{small globb} &\globb{4}{narrower, one-fourth of a page width} \cr
%\cr
%fifth --             &\globb{5}{\longtext}  \cr
%}
%Note the direct text in column two `direct too'
%is no further left than the globb text.
%Now this is after the globb and is being used  to show that
%the paragraph stuff and all the interlineskip is back to normal.
%
%Is it? It looks like the line after the last  globb in the halign
%doesnt get enough space before printing the next line.
%This can be patched with a blank line at the end of the table (/cr),
%but `should' not be necessary.
%
%% Also, problems can occur if halign format puts input through a macro.
% as in \def\lft#1{#1\hfil}   \halign{\lft{#}\cr   ... minor..
%
%%\end
