From:	MX%"art@cs.ualberta.ca"  6-OCT-1992 01:16:34.02
To:	BED_GDG
CC:	
Subj:	Submission to TeX archive

Return-Path: <@scapa.cs.ualberta.ca:art@cs.ualberta.ca>
Received: from scapa.cs.ualberta.ca by Niord.SHSU.edu (MX V3.1B) with SMTP;
          Tue, 06 Oct 1992 00:56:27 CDT
Received: from scapa by scapa.cs.ualberta.ca via suspension id <42150-2>; Mon,
          5 Oct 1992 23:53:55 -0600
Received: from scapa by scapa.cs.ualberta.ca via suspension id <42480-2>; Mon,
          5 Oct 1992 17:27:16 -0600
Received: from edwand.cs.ualberta.ca by scapa.cs.ualberta.ca id <42363-2>; Mon,
          5 Oct 1992 08:38:41 -0600
Subject: Submission to TeX archive
From: Art Mulder <art@cs.ualberta.ca>
To: bed_gdg@SHSU.edu (George D. Greenwade)
Date: Mon, 5 Oct 1992 08:38:30 -0600
In-Reply-To: <00961718.39D961C0.14002@SHSU.edu>; from "George D. Greenwade" at
    Oct 1, 92 12:45 pm
X-Mailer: ELM [version 2.3 PL11]
Message-ID: <92Oct5.083841mdt.42363-2@scapa.cs.ualberta.ca>

George,
  I tried to ftp to pip.shsu.edu but couldn't.  (My system couldn't
  get an address for that name).

  So, here are my submission, via email.

  There are two files:  shading.sty, shading.tex

  I obtained shading.sty from your archives a week or so back, and this
  is a resubmission, with a minor bug fix.  I emailed to
  leo@vaxc.cc.monash.edu.au, the original author of the TeX code, and he
  gave me permission to resubmit this.  I did *not* try and email
  to mroth@afit.af.mil, who converted the TeX code to a LaTeX style file.  I
  didn't think that necessary.

  In addition, shading.tex is a short (~3 page) set of instructions on
  the use of shading.sty, which I wrote.

  Finally, I attached a "standard" file header to the two files, using the
  method suggested by D.M. Jones and Nelson Beebe.

  Shading.sty is a LaTeX style file that lets you set text on a shaded
  background.  It uses embedded PostScript to do this, and so requires a
  postscript printer.

---cut here for shading.sty---
%%% ====================================================================
%%%  @LaTeX-style-file{
%%%     author          = "Art Mulder",
%%%     version         = "1.3",
%%%     date            = "29 September 1992",
%%%     time            = "08:23:05 MDT",
%%%     filename        = "shading.sty",
%%%     address         = "Department of Computing Science
%%%                        615 General Services Building
%%%                        University of Alberta
%%%                        Edmonton, Alberta
%%%                        T6G 2H1, Canada.",
%%%     telephone       = "n/a",
%%%     FAX             = "(403) 492-1071",
%%%     checksum        = "",
%%%     email           = "art@cs.ualberta.ca",
%%%     codetable       = "ISO/ASCII",
%%%     keywords        = "",
%%%     supported       = "yes",
%%%     abstract        = "",
%%%     docstring       = "A LaTeX Style file for putting text on a
%%%     		   shaded background.  Requires a PostScript
%%%			   printer and dvi-file converter.
%%%
%%%			   NOTE: Art Mulder is not the author
%%%			   of this file, just the most recent
%%%			   modifier.
%%%
%%%			   The style file is based upon ideas by
%%%			   Je'ro^me Maillot, maillot@bora.inria.fr
%%%			   which where turned into TeX code by
%%%			   Leo, LEO@vaxc.cc.monash.edu.au.
%%%			   That TeX code was converted into a LaTeX
%%%			   style file by M.A.R. ( mroth@afit.af.mil )",
%%%  }
%%% ====================================================================

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 'Shading.sty'
%
% Art Mulder ( art@cs.ualberta.ca ) 28-Sept-1992
%  - Changed name of "linewidth" variable to "outlineboxwidth".
%    That variable name conflicted with another variable of the same
%    name in "latex.tex" when doing miniparagraphs.
%  - Wrote accompanying document ``shading.tex'', brief instructions
%    in the use of this style file, together with several examples.
%
% M.A.R. ( mroth@afit.af.mil ) 22 Jan 92
%  - Modified to work as a LaTeX style:
%  - added setting the grayscale as an optional argument.
%  - allowed multiple paragraphs in the \parashade command
%
% Leo ??  ( LEO@vaxc.cc.monash.edu.au )
%  - Wrote the original TeX code, based upon some ideas
%    from Je'ro^me Maillot ( maillot@bora.inria.fr ).
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  USAGE: \textshade[grayscale]{corneroption}{text to be shaded}
%         \parashade[grayscale]{corneroption}{paragraph(s) to be shaded}
%         where
%         grayscale is a number from 0 to 1, the higher the number the
%                   lighter the shading, if missing it is set to 0.95
%         corneroption is either sharpcorners or roundcorners
%
%  LIMITATIONS: --can not break the shaded text across lines (\textshade) or
%                 across pages (both)
%               --can not specify the line width of the surrounding box or
%                 the amount of space between the surrounding
%                 box and the text to be shaded as arguments
%		  (Actually you can, see the use of "\gdef" in the example)
%               --modifying the xgrayspace and ygrayspace in the argument
%                 will only affect the space added to the right and
%                 bottom of the box, respectively
%
%  EXAMPLES:
%    This is a test of a\ \textshade[1]{roundcorners}{shaded box} routine.
%    With a grayscale of 1, we essentially get no shading, and just a box.
%
%    This is another test of a\ \textshade{sharpcorners}{shaded box} routine.
%    The default shading of .95 is used here.
%
%    \parashade[.995]{roundcorners}{\gdef\outlineboxwidth{.5}%
%    This is one very long line which I expect will be broken over one or more
%    lines. The idea is to have this paragraph enclosed in a shaded box. I'll
%    just keep on typing until I can be sure that there are more than two lines
%    in this paragraph. I expect that this should be well and truely sufficient
%    to test this macro.
%    } %This shows an example of changing the outlineboxwidth used, without
%      %changing the style
%
%    The field equations of General Relativity are\ %
%%
%    \textshade{roundcorners}{\hbox{$G_{\mu\nu} = kT_{\mu\nu}$}}
%
%    They can also be written as
%
%   \parashade{sharpcorners}{$$R_{\mu\nu}-{1\over2}g_{\mu\nu}R = kT_{\mu\nu}$$}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newbox\graybox
\newdimen\xgrayspace
\newdimen\ygrayspace

%----------------------------------------------------------------------------
%
% The following \TeX code was based on previous work by
%
%            Je'ro^me Maillot, maillot@bora.inria.fr
%
%----------------------------------------------------------------------------
%
% Use the following for one or more words within a line.
%
%MAR-added ability for optional argument for user to set grayscale
\def\textshade{\@ifnextchar[{\@textshade}{\@textshade[0.95]}}
\def\@textshade[#1]#2#3{%
    \xgrayspace=4pt%
    \ygrayspace=4pt%
    \def\grayshade{#1}%
    \def\outlineboxwidth{1}%
    \def\theradius{5}%
    \setbox\graybox=\hbox{\surroundboxa{#3}}%
    \hbox{%
    \hbox to 0pt{%
    \special{"gsave newpath 0 0 moveto                                %
        0                                    1 copy /xmin exch store  %
        \number\dp\graybox \space -65536 div 1 copy /ymin exch store  %
        \number\wd\graybox \space  65536 div 1 copy /xmax exch store  %
        \number\ht\graybox \space  65536 div 1 copy /ymax exch store  %
        \theradius\space                            /radius exch store
        \outlineboxwidth\space                      /linewidth exch store
        \grayshade\space                            /grayshade exch store
        #2 grestore}}%
    \box\graybox}}%
%
% Use the following for paragraphs.
%
%MAR-added ability for optional argument for user to set grayscale
\def\parashade{\@ifnextchar[{\@parashade}{\@parashade[0.95]}}
%MAR-added \long to allow multiple paragraphs in one shaded block
\long\def\@parashade[#1]#2#3{%
    \xgrayspace=10pt%
    \ygrayspace=10pt%
    \def\grayshade{#1}%
    \def\outlineboxwidth{2}%
    \def\theradius{10}%
    \def\thevskip{15pt}%
    \setbox\graybox=\hbox{\surroundboxb{#3}}%
    \vskip\thevskip
    \hbox{%
    \hbox to 0pt{%
    \special{"gsave newpath 0 0 moveto                                %
        0                                    1 copy /xmin exch store  %
        \number\dp\graybox \space -65536 div 1 copy /ymin exch store  %
        \number\wd\graybox \space  65536 div 1 copy /xmax exch store  %
        \number\ht\graybox \space  65536 div 1 copy /ymax exch store  %
        \theradius\space                            /radius exch store
        \outlineboxwidth\space                      /linewidth exch store
        \grayshade\space                            /grayshade exch store
        #2 grestore}}%
     \box\graybox}%
     \vskip\thevskip%
}%
%----------------------------------------------------------------------------
%
% A pair of box macros. Each builds a slightly oversized box
% containing the text. The text is centred both in the vertical
% horizontal directions.
%
% Use the following for one or more words within a line.
%
\long\def\surroundboxa#1{\leavevmode\hbox{\vtop{%
\vbox{\kern\ygrayspace%
\hbox{\kern\xgrayspace#1%
      \kern\xgrayspace}}\kern\ygrayspace}}}
%
% Use the following for a paragraphs.
%
\long\def\surroundboxb#1{\leavevmode\hbox{\vtop{%
\vbox{\kern\ygrayspace%
\hbox{\kern\xgrayspace\vbox{\advance\hsize-2\xgrayspace#1}%
      \kern\xgrayspace}}\kern\ygrayspace}}}
%----------------------------------------------------------------------------
%
% Here are some simple PostScript routines.
%
% The TeX command \PScommands must be called before any of the
% shading routines can be used.
%
\long\def\PScommands{\special{! TeXDict begin
%
/sharpbox{%
           newpath
           xmin ymin moveto
           xmin ymax lineto
           xmax ymax lineto
           xmax ymin lineto
           xmin ymin lineto
           closepath
          }bind def
%
/roundbox{%
           newpath
           xmin radius add ymin moveto
           xmax ymin xmax ymax radius arcto
           xmax ymax xmin ymax radius arcto
           xmin ymax xmin ymin radius arcto
           xmin ymin xmax ymin radius arcto 16 {pop} repeat
           closepath
          }bind def
%
/sharpcorners{%
               sharpbox gsave grayshade setgray fill grestore
               linewidth setlinewidth stroke
              }bind def
%
/plainbox{%
           sharpbox grayshade setgray fill
          }bind def
%
/roundcorners{%
               roundbox gsave grayshade setgray fill grestore
               linewidth setlinewidth stroke
              }bind def
%
end}%                   Closes dictionnary
}%

\PScommands
%----------------------------------------------------------------------------
%	End of file
---cut here -> end of shading.sty---

---cut here for shading.tex---
%%% ====================================================================
%%%  @LaTeX-file{
%%%     author          = "Art Mulder",
%%%     version         = "1.1",
%%%     date            = "29 September 1992",
%%%     time            = "08:30:45 MDT",
%%%     filename        = "shading.tex",
%%%     address         = "Department of Computing Science
%%%                        615 General Services Building
%%%                        University of Alberta
%%%                        Edmonton, Alberta
%%%                        T6G 2H1, Canada.",
%%%     telephone       = "n/a",
%%%     FAX             = "(403) 492-1071",
%%%     checksum        = "228    1021    8397",
%%%     email           = "art@cs.ualberta.ca",
%%%     codetable       = "ISO/ASCII",
%%%     keywords        = "",
%%%     supported       = "yes",
%%%     abstract        = "",
%%%     docstring       = "The LaTeX document briefly describes the
%%%     		   LaTeX style file ``shading.sty''.
%%%			   Shading.sty is a style file for putting
%%%			   text on a shaded background in LaTeX.
%%%
%%%			   Requires a Postscript printer and
%%%			   dvi converter",
%%%  }
%%% ====================================================================
\documentstyle[12pt, moretext, shading]{article}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% shading.tex 				Art Mulder ( art@cs.ualberta.ca )
% 25 September, 1992
%
% A brief manual on the use of the "shading.sty" LaTeX style file.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Usage:
%   - Process this file with latex.  (The file "shading.sty" must either
%     be in a standard location with the other LaTeX style files, or in
%     the same directory as this file).
%   - Convert to postscript, via a tool such as "dvips"
%   - either view with a Postscript previewer (like ghostview) or
%     print to a postscript printer.
%
% In the above \documentstyle command, the style file ``moretext'' is
% optional.  It simply shrinks the margins to something that I like a
% bit better than the default values for article.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Help yourself to whatever you want from this file.
% Caveat Emptor.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\begin{document}

%	Title "Page"
%---------------------------------------------------------------------------
\title{The {\tt shading.sty} document style}
\author{Arthur E. Mulder\thanks{Author of this document only.  The
  style file itself has had several authors / contributors:
  J\'{e}r\^{o}me Maillot ({\tt maillot@bora.inria.fr}),
  Leo ??  ({\tt LEO@vaxc.cc.monash.edu.au}), and
  M.A.R. ({\tt mroth@afit.af.mil}).}
\date{29 September 1992 \\
Version 1.01}
\maketitle

%---------------------------------------------------------------------------

\section{Introduction}
  The purpose of this style file is to permit you, in LaTeX, to place text
  in a box with a shaded background.  This particular solution uses
  Postscript to do so, and is therefore of no use to you if you do not have
  a postscript printer.  Furthermore, if you wish to be able to preview your
  document before printing, you will also need a Postscript viewer, such as
  {\tt Ghostview}.

%---------------------------------------------------------------------------
\section{Usage}
  To use this style option, you must add the name of the style file, {\tt
  shading} to the {\tt documentstyle} command in your document:

  \begin{quote}
	\verb|\documentstyle[... shading ...]{article}|
  \end{quote}

  Note that this should also work with teh {\tt report} and {\tt book}
  styles.  You are not restricted to using the {\tt article} style.

\subsection{Shading Commands}
  There are two commands provided by this style:

  \begin{quote}
    \verb|\textshade|[{\em grayscale}]\{{\em corneroption}\}\{{\em text
	to be shaded}\}

    \verb|\parashade|[{\em grayscale}]\{{\em corneroption}\}\{{\em paragraph
	to be shaded}\}
  \end{quote}


  \begin{tabular}{lp{4.5in}}
  {\tt grayscale} & This is a number from 0 to 1.  The higher the number,
		  the {\em lighter} the resulting shading.  With a value
		  of 1, there is essentially no shading, and you end up
		  with just a box.  A value of 0 is probably of little
		  practical use.  If this value is omitted, a default
		  value of .95 is used. \\
  {\tt corneroption} &   This is either the {\tt sharpcorners} or
		    {\tt roundcorners}, with obvious effects upon the box
		    that is drawn. \\
  \end{tabular}


\subsection{Limitations}
  There are a number of limitations that go along with this style:

  \begin{itemize}

    \item You can not break text across lines within the \verb|\textshade|
      command.

    \item You can not break text across pages with either command.

    \item You can not specify the line width of the surrounding box, or
      the amount of space between the surrounding box and the text to
      be shaded {\em as arguments}.

      See the examples below for how you {\em can}
      fiddle with the line width of the surrounding box.

    \item Modifying the xgrayspace and ygrayspace in the argument
      will only affect the space added to the right and
      bottom of the box, respectively.

  \end{itemize}

%---------------------------------------------------------------------------
\section{Examples of Usage}

%
%% 1)
%
\subsection{}
  \noindent\begin{minipage}{3in}
    This is a test of a\ \textshade[1]{roundcorners}{shaded box} routine.
    With a grayscale of 1, we essentially get no shading, and just a box.
  \end{minipage}\hspace{.25in}\begin{minipage}{3in}
    \begin{verbatim}
This is a test of a\
\textshade[1]{roundcorners}{shaded box}
routine.  With a ...
     \end{verbatim}\end{minipage}

%
%% 2)
%
\subsection{}
  \noindent\begin{minipage}{3in}
    This is another test of a\ \textshade{sharpcorners}{shaded box}
    routine.  The default shading of .95 is used here.  Note also the difference
    between a ``sharpcorners'' and a ``roundcorners'' box.
  \end{minipage}\hspace{.25in}\begin{minipage}{3in}
\begin{verbatim}
...
\textshade{sharpcorners}{shaded box}
...
\end{verbatim}
\end{minipage}

%
%% 3)
%
\subsection{}
\noindent\begin{minipage}{3in}
    \parashade[.995]{roundcorners}{\gdef\outlineboxwidth{.5}%
    This is one very long line which I expect will be broken over one or more
    lines. The idea is to have this paragraph enclosed in a shaded box. I'll
    just keep on typing until I can be sure that there are more than two lines
    in this paragraph.
    }
 \end{minipage}\hspace{.25in}
\begin{minipage}{3in}

\begin{verbatim}
\parashade[.995]{roundcorners}
{\gdef\outlineboxwidth{.5}%
This is one very ... paragraph.}
\end{verbatim}\end{minipage}

  \smallskip
    In the prior example, take note of how the width of the box surrounding
    the paragraph was changed from it's default of 2 (points?) to .5,
    through the use of the \verb|\gdef\outlineboxwidth{.5}| command.

    This is probably a pretty kludgey way of doing it, but it works well
    enough for now.  If you feel like fixing it up, you're welcome to give
    it a try!

%
%% 4)
%
\subsection{}
  \noindent\begin{minipage}{3in}
    So, let's try fiddling with the linewidth to get
    \textshade[.8]{sharpcorners}{\gdef\outlineboxwidth{0}no box}
    around this text.  Not bad, eh?
  \end{minipage}\hspace{.25in}\begin{minipage}{3in}
\begin{verbatim}
...
\textshade[.8]{sharpcorners}
{\gdef\outlineboxwidth{0}no box}
...
\end{verbatim}\end{minipage}

%---------------------------------------------------------------------------
\section{Moving On\ldots}
  For further information about ways that you can tweak this style to serve
  you better, please see the source code for the style:  {\tt shading.sty}

%---------------------------------------------------------------------------
\section{Caveat Emptor}
  I did not write or design this document style option.  I simply wrote this
  document, first as an exercise in trying out the shading document style,
  and secondly as a service to any others whom I might pass this on to.
  A fair amount of the content of this file came from the contents of the
  style file {\tt shading.sty}. \hfill {\em \ldots Art Mulder, 9/25/92}
%---------------------------------------------------------------------------
\end{document}

---cut here -> end of shading.tex---

regards,
...art mulder
